extends Control
class_name LockscreenControls

@onready var music = get_parent().find_child("MusicPlayer") as MusicPlayer
@onready var generator = get_parent().find_child("Generator") as Generator

@onready var ana_list = find_child("Analysis") as VBoxContainer

@onready var lyrics = find_child("Lyrics") as RichTextLabel

var vcurves = Array()
var slow = false

func _ready():
	if music.now_playing.size() == 0:
		visible = false
	pass
	
func _input(event):
	if event.is_action_pressed("lockscreen"):
		toggle_visibility()
		

func create_value_curves():
	for v in vcurves:
		v.free()
	
	vcurves.clear()
	
	if vcurves.size() == 0:
		for i in range(0, 3):
			var vcurve = ValuesCurve.new()
			vcurve.setup_type("solid")
			vcurve.mesh = ResourceLoader.load("res://ValuesMesh.tres", "", ResourceLoader.CACHE_MODE_IGNORE).duplicate()
			vcurve.col = i
			vcurve.position.x = 0
			vcurve.con_width = ana_list.get_rect().size.x
			vcurve.position.y = 128#(i+1) * 192
			vcurve.cols = generator.cols
			vcurve.load_windowed_song(music.packed_values)
			#vcurve.refresh_windowed2()
			vcurves.append(vcurve)
			(ana_list.get_child((i*2)) as RichTextLabel).text = generator.col_names[generator.cols[vcurve.col]]
			ana_list.get_child(1+(i*2)).call_deferred("add_child", vcurve)
			
	if music.now_playing.get("tags"):
			var s = music.now_playing["tags"]
			var l = s["lyrics"]
			lyrics.text = l

func toggle_visibility():
	if !slow and !visible:
		visible = true
		Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
		$"/root/Node3D/Player".find_child("PlayerNode").mouse_captured = false
		
		if find_child("Analysis").visible:
			create_value_curves()
	
	elif slow and visible:
		slow = false
		Engine.set_max_fps(60)
		
		visible = false
	
	elif !slow and visible:
		Engine.set_max_fps(1)
		slow = true
		
